<?php
// visitor message stats
// by www.vietdjclub.com - dj Truc
// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('cpuser', 'forum', 'timezone', 'user');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_user.php');
$this_script = 'visitor_mes_stats';

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminusers'))
{
	print_cp_no_permission();
}

$vbulletin->input->clean_array_gpc('r', array(
	'avatarid' => TYPE_INT,
	'userid'   => TYPE_INT,
));

if (is_browser('webkit') AND $vbulletin->GPC['avatarid'] AND empty($_POST['do']))
{
	$_POST['do'] = $_REQUEST['do'] = 'updateavatar';
}

// ############################# LOG ACTION ###############################
log_admin_action(!empty($vbulletin->GPC['userid']) ? 'user id = ' . $vbulletin->GPC['userid'] : '');

print_cp_header($vbphrase['user_manager']);

/////////////////////// front page
if (empty($_REQUEST['do']))
{

	$vms = $db->query_read("
		SELECT COUNT(*) AS total, userid FROM " . TABLE_PREFIX . "visitormessage GROUP BY userid ORDER BY total DESC");

	print_form_header($this_script, '');
	print_table_header('  ',3);
	print_cells_row(array($vbphrase['number_of_messages'], $vbphrase['number_of_users'], $vbphrase['controls']), 1);

	$groups = array();
	while ($vm = $db->fetch_array($vms))
	{
		$groups["$vm[total]"]++;
	}
	foreach ($groups AS $key => $total)
	{
		$cell = array();
		$cell[] = $key . iif($vbulletin->options['pmquota'], '/' . $vbulletin->options['pmquota']);
		$cell[] = $total;
		$cell[] = construct_link_code(construct_phrase($vbphrase['list_users_with_x_messages'], $key), "visitor_mes_stats.php?" . $vbulletin->session->vars['sessionurl'] . "do=vmuserstats&total=$key");
		print_cells_row($cell);
	}
	print_table_footer();

}

// ############################# start VM stats #########################
if ($_REQUEST['do'] == 'vmuserstats')
{

	$vbulletin->input->clean_array_gpc('r', array(
		'total' => TYPE_UINT
	));

	$users = $db->query_read("
		SELECT COUNT( * ) AS total, visme.userid, user.username, user.lastactivity, user.email
		FROM " . TABLE_PREFIX . "visitormessage AS visme
		INNER JOIN " . TABLE_PREFIX . "user AS user ON (visme.userid = user.userid)
		GROUP BY visme.userid
		HAVING total = " . $vbulletin->GPC['total'] . "
		ORDER BY user.username DESC
	");

	if (!$db->num_rows($users))
	{
		print_stop_message('no_users_matched_your_query');
	}

	// a little javascript for the options menus
	?>
	<script type="text/javascript">
	function js_pm_jump(userid,username)
	{
		value = eval("document.cpform.u" + userid + ".options[document.cpform.u" + userid + ".selectedIndex].value");
		var page = '';
		switch (value)
		{
			case 'profile': page = "user.php?do=edit&u=" + userid; break;
			case 'pmuser': page = "../private.php?do=newpm&u=" + userid; break;
			case 'delete': page = "visitor_mes_stats.php?do=removevms&u=" + userid; break;
		}
		if (page != '')
		{
			window.location = page + "&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";
		}
		else
		{
			window.location = "mailto:" + value;
		}
	}
	</script>
	<?php

	print_form_header($this_script, '');
	print_table_header('     ', 3);
	print_cells_row(array($vbphrase['username'], $vbphrase['last_activity'], $vbphrase['options']), 1);
	while($user = $db->fetch_array($users))
	{
		$cell = array();
		$cell[] = "<a href=\"../member.php?" . $vbulletin->session->vars['sessionurl'] . "do=getinfo&amp;u=$user[userid]\" target=\"_blank\">$user[username]</a>";
		$cell[] = vbdate($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $user['lastactivity']);
		$cell[] = "
		<select name=\"u$user[userid]\" onchange=\"js_pm_jump($user[userid], '$user[username]');\" tabindex=\"1\" class=\"bginput\">
			<option value=\"profile\">" . $vbphrase['edit_user'] . "</option>
			" . (!empty($user['email']) ? "<option value=\"$user[email]\">" . $vbphrase['send_email_to_user'] . "</option>" : "") . "
			<option value=\"pmuser\">" . $vbphrase['send_private_message_to_user'] . "</option>
			<option value=\"delete\">" . construct_phrase($vbphrase['delete_all_users_visitor_messages']) . "</option>
		</select><input type=\"button\" class=\"button\" value=\"$vbphrase[go]\" onclick=\"js_pm_jump($user[userid], '$user[username]');\" tabindex=\"1\" />\n\t";
		print_cells_row($cell);
	}
	print_table_footer();

}

// ###################### Start Remove User's VMs #######################
if ($_REQUEST['do'] == 'removevms')
{

	print_delete_confirmation('user', $vbulletin->GPC['userid'], $this_script, 'killvms', 'private_messages_belonging_to_the_user');
}

// ###################### Start Remove User's VMs #######################
if ($_POST['do'] == 'killvms')
{

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "visitormessage WHERE userid = " . $vbulletin->GPC['userid']);
	define('CP_REDIRECT', "visitor_mes_stats.php?");
	print_stop_message('deleted_private_messages_successfully');
}

function vsm_print_footer () {
	echo '<p align="center"><a href="" target="_blank" class="copyright"></a></p>';
}
vsm_print_footer();
print_cp_footer();
?>
